<?php
/**
 * Media Posts Section options
 *
 * @package Theme Palace
 * @subpackage Rise Magazine
 * @since Rise Magazine 1.0.0
 */

// Add Media Posts section
$wp_customize->add_section( 'rise_magazine_media_posts_section',
    array(
        'title'             => esc_html__( 'Media Posts','rise-magazine' ),
        'description'       => esc_html__( 'Media Posts Section options.', 'rise-magazine' ),
        'panel'             => 'rise_magazine_front_page_panel',
    )
);

// Media Posts content enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[media_posts_section_enable]',
    array(
        'default'           =>  $options['media_posts_section_enable'],
        'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Rise_Magazine_Switch_Control( $wp_customize,
    'rise_magazine_theme_options[media_posts_section_enable]',
        array(
            'label'             => esc_html__( 'Media Posts Section Enable', 'rise-magazine' ),
            'section'           => 'rise_magazine_media_posts_section',
            'on_off_label'      => rise_magazine_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'rise_magazine_theme_options[media_posts_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['media_posts_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'rise_magazine_theme_options[media_posts_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'rise-magazine' ),
        'section'           => 'rise_magazine_media_posts_section',
        'active_callback'   => 'rise_magazine_is_media_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'rise_magazine_theme_options[media_posts_title]',
        array(
            'selector'            => '#rise_magazine_media_posts_section .section-header h2',
            'settings'            => 'rise_magazine_theme_options[media_posts_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'rise_magazine_media_posts_title_partial',
        )
    );
}


// Add dropdown categories setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[media_posts_category_exclude]',
    array(
        'sanitize_callback' => 'rise_magazine_sanitize_category_list',
    )
);

$wp_customize->add_control( new Rise_Magazine_Dropdown_Multiple_Chooser( $wp_customize,
    'rise_magazine_theme_options[media_posts_category_exclude]',
        array(
            'label'             => esc_html__( 'Select Excluding Categories', 'rise-magazine' ),
            'section'           => 'rise_magazine_media_posts_section',
            'type'              => 'dropdown_multiple_chooser',
            'choices'           =>  rise_magazine_category_choices(),
            'active_callback'   => 'rise_magazine_is_media_posts_section_enable'
        )
    )
);
