<?php
/**
 * Post Slider Section options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add Post Slider section
$wp_customize->add_section( 'rise_magazine_post_slider_section',
	array(
		'title'             => esc_html__( 'Post Slider','rise-magazine' ),
		'description'       => esc_html__( 'Post Slider Section options.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_front_page_panel',
	)
);

// Post Slider content enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[post_slider_section_enable]', 
	array(
		'default'			=> 	$options['post_slider_section_enable'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	) 
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[post_slider_section_enable]',
		array(
			'label'             => esc_html__( 'Post Slider Section Enable', 'rise-magazine' ),
			'section'           => 'rise_magazine_post_slider_section',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);

// Post Slider autoplay enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[post_slider_autoplay_enable]',
	array(
		'default'			=> 	$options['post_slider_autoplay_enable'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[post_slider_autoplay_enable]',
		array(
			'label'             => esc_html__( 'Post Slider Autoplay Enable', 'rise-magazine' ),
			'section'           => 'rise_magazine_post_slider_section',
			'active_callback'   => 'rise_magazine_is_post_slider_section_enable',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);

// post_slider title setting and control
$wp_customize->add_setting( 'rise_magazine_theme_options[post_slider_title]',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => $options['post_slider_title'],
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'rise_magazine_theme_options[post_slider_title]',
    array(
        'label'             => esc_html__( 'Section Title', 'rise-magazine' ),
        'section'           => 'rise_magazine_post_slider_section',
        'active_callback'   => 'rise_magazine_is_post_slider_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'rise_magazine_theme_options[post_slider_title]',
        array(
            'selector'            => '#rise_magazine_post_slider_section .section-header h2',
            'settings'            => 'rise_magazine_theme_options[post_slider_title]',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'rise_magazine_post_slider_title_partial',
        )
    );
}


for ( $i = 1; $i <= 3; $i++ ) :

	// slider posts drop down chooser control and setting
	$wp_customize->add_setting( 'rise_magazine_theme_options[post_slider_content_post_'. $i .']', 
		array(
			'sanitize_callback' => 'rise_magazine_sanitize_page',
		)
	);

	$wp_customize->add_control( new  Rise_Magazine_Dropdown_Chooser( $wp_customize,
		'rise_magazine_theme_options[post_slider_content_post_'. $i .']',
			array(
				'label'             => sprintf(esc_html__( 'Select Post : %d', 'rise-magazine'), $i ),
				'section'           => 'rise_magazine_post_slider_section',
				'choices'			=> rise_magazine_post_choices(),
				'active_callback'	=> 'rise_magazine_is_post_slider_section_enable',
			)
		)
	);

	// Rise_Magazine_Customize_Horizontal_Line
    $wp_customize->add_setting('rise_magazine_theme_options[post_slider_separator'. $i .']',
		array(
			'sanitize_callback'      => 'rise_magazine_sanitize_html',
		)
	);

    $wp_customize->add_control(new Rise_Magazine_Customize_Horizontal_Line($wp_customize,
		'rise_magazine_theme_options[post_slider_separator'. $i .']',
			array(
				'active_callback'       => 'rise_magazine_is_post_slider_section_enable',
				'type'                  =>'hr',
				'section'               =>'rise_magazine_post_slider_section',
			)
		)
	);

endfor;
