<?php
/**
 * Archive options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add archive section
$wp_customize->add_section( 'rise_magazine_archive_section',
	array(
		'title'             => esc_html__( 'Blog/Archive','rise-magazine' ),
		'description'       => esc_html__( 'Archive section options.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_theme_options_panel',
	)
);

// Your latest posts title setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[your_latest_posts_title]',
	array(
		'default'           => $options['your_latest_posts_title'],
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[your_latest_posts_title]',
	array(
		'label'             => esc_html__( 'Your Latest Posts Title', 'rise-magazine' ),
		'description'       => esc_html__( 'This option only works if Static Front Page is set to "Your latest posts."', 'rise-magazine' ),
		'section'           => 'rise_magazine_archive_section',
		'type'				=> 'text',
		'active_callback'	=> function( $control ) {
			return !(
				rise_magazine_is_static_homepage_enable( $control )
			);
		}
	)
);


// Archive tag category setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[hide_category]',
	array(
		'default'           => $options['hide_category'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[hide_category]',
		array(
			'label'             => esc_html__( 'Hide Category', 'rise-magazine' ),
			'section'           => 'rise_magazine_archive_section',
			'on_off_label' 		=> rise_magazine_hide_options(),
		)
	)
);

// Archive tag category setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[hide_date]',
	array(
		'default'           => $options['hide_date'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[hide_date]',
		array(
			'label'             => esc_html__( 'Hide Date', 'rise-magazine' ),
			'section'           => 'rise_magazine_archive_section',
			'on_off_label' 		=> rise_magazine_hide_options(),
		)
	)
);

