<?php
/**
 * Menu options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'rise_magazine_menu',
	array(
		'title'             => esc_html__('Header Menu','rise-magazine'),
		'description'       => esc_html__( 'Header Menu options.', 'rise-magazine' ),
		'panel'             => 'nav_menus',
	)
);


$wp_customize->add_setting( 'rise_magazine_theme_options[search_icon_in_primary_menu_enable]',
	array(
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
		'default'           => $options['search_icon_in_primary_menu_enable'],
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[search_icon_in_primary_menu_enable]',
		array(
			'label'             => esc_html__( 'Show Search Icon', 'rise-magazine' ),
			'description'       => esc_html__( 'Show Search Icon in Primary menu', 'rise-magazine' ),
			'section'           => 'rise_magazine_menu',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);

// ads image setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[ads_image]',
	array(
		'sanitize_callback' => 'rise_magazine_sanitize_image'
	)
);

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,
	'rise_magazine_theme_options[ads_image]',
		array(
			'label'       		=> esc_html__( 'Advertisement Image', 'rise-magazine' ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'rise-magazine' ), 900, 100 ),
			'section'     		=> 'rise_magazine_menu',
		)
	)
);

// ads link setting and control
$wp_customize->add_setting( 'rise_magazine_theme_options[ads_url]',
	array(
		'sanitize_callback' => 'esc_url_raw',
		)
	);
	
	$wp_customize->add_control( 'rise_magazine_theme_options[ads_url]',
	array(
		'label'           	=> esc_html__( 'Advertisement Url', 'rise-magazine' ),
		'section'        	=> 'rise_magazine_menu',
		'type'				=> 'url',
	)
);