<?php
/**
 * Breaking News section
 *
 * This is the template for the content of Breaking News section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_breaking_news_section' ) ) :
    /**
    * Add Breaking News section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_breaking_news_section() {
        $options = rise_magazine_get_theme_options();
        // Check if Breaking News is enabled on frontpage
        $breaking_news_enable = apply_filters( 'rise_magazine_section_status', true, 'breaking_news_section_enable' );

        if ( true !== $breaking_news_enable ) {
            return false;
        }
        // Get Breaking News section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_breaking_news_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render Breaking News section now.
        rise_magazine_render_breaking_news_section( $section_details );
    }
endif;

if ( ! function_exists( 'rise_magazine_get_breaking_news_section_details' ) ) :
    /**
    * Breaking News section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input breaking_news section details.
    */
    function rise_magazine_get_breaking_news_section_details( $input ) {
        $options = rise_magazine_get_theme_options();
        
        $content = array();

        $cat_id = ! empty( $options['breaking_news_content_category'] ) ? $options['breaking_news_content_category'] : '';
        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => 4,
            'cat'                   => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    
         

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// Breaking News section content details.
add_filter( 'rise_magazine_filter_breaking_news_section_details', 'rise_magazine_get_breaking_news_section_details' );


if ( ! function_exists( 'rise_magazine_render_breaking_news_section' ) ) :
  /**
   * Start Breaking News section
   *
   * @return string Breaking News content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_breaking_news_section( $content_details = array() ) {
        $options                = rise_magazine_get_theme_options();
        $breaking_news_autoplay_enable = ($options['breaking_news_autoplay_enable']) ? 'true' : 'false';

        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="magazine_pro_breaking_news_section" class="relative wrapper">
                <div class="breaking-news-wrapper">
                    <h2 class="news-title"><?php echo esc_html($options['breaking_news_title']); ?></h2>
                    <div class="breaking-news-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows": false, "autoplay": <?php echo esc_attr($breaking_news_autoplay_enable); ?>, "draggable": true, "fade": false }'>
                    <?php foreach($content_details as $content) : ?>
                        <article>
                            <div class="breaking-news-item-wrapper">
                                <div class="featured-image">
                                    <img src="<?php echo esc_url($content['image']);?>" alt="<?php echo esc_attr($content['title']); ?>">
                                </div><!-- .featured-image -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                </header>
                            </div><!-- .breaking-news-item-wrapper -->
                        </article>
                        <?php endforeach; ?>

                    </div><!-- .breaking-news-slider -->
                </div><!-- .breaking-news-wrapper -->
            </div><!-- #magazine_breaking_news_section -->
    <?php }
endif;  ?>
