<?php
/**
 * Blog section
 *
 * This is the template for the content of media_posts section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_media_posts_section' ) ) :
    /**
    * Add media_posts section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_media_posts_section() {
        $options = rise_magazine_get_theme_options();
        // Check if media_posts is enabled on frontpage
        $media_posts_enable = apply_filters( 'rise_magazine_section_status', true, 'media_posts_section_enable' );

        if ( true !== $media_posts_enable ) {
            return false;
        }
        // Get media_posts section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_media_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render media_posts section now.
        rise_magazine_render_media_posts_section( $section_details );
    }
endif;

if ( ! function_exists( 'rise_magazine_get_media_posts_section_details' ) ) :
    /**
    * media_posts section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input media_posts section details.
    */
    function rise_magazine_get_media_posts_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $media_posts_count = 5;
        
        $content = array();

        $cat_ids = ! empty( $options['media_posts_category_exclude'] ) ? $options['media_posts_category_exclude'] : array();
        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => absint( $media_posts_count ),
            'category__not_in'      => ( array ) $cat_ids,
            'ignore_sticky_posts'   => true,
        );                    
    
        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = rise_magazine_trim_content( $options['media_posts_excerpt_length']);
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// media_posts section content details.
add_filter( 'rise_magazine_filter_media_posts_section_details', 'rise_magazine_get_media_posts_section_details' );


if ( ! function_exists( 'rise_magazine_render_media_posts_section' ) ) :
  /**
   * Start media_posts section
   *
   * @return string media_posts content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_media_posts_section( $content_details = array() ) {
        $options                = rise_magazine_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        }
        $first_post = array_shift($content_details); ?>
            <div id="magazine_pro_media_posts_section" class="relative grid-layout">
                <?php if ( !empty( $options['media_posts_title'] ) ): ?>
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( $options['media_posts_title'] ); ?></h2>
                    </div><!-- .section-header -->
                <?php endif ?>

                <div class="media-posts-wrapper col-2 clear">
                    <div class="half-width grid-layout">
                        <article class="has-post-thumbnail">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url($first_post['image']); ?>');">
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <div class="entry-meta">
                                    <?php rise_magazine_posted_on($first_post['id']); ?>
                                    <?php echo rise_magazine_author($first_post['id']); ?>
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($first_post['url']); ?>"><?php echo esc_html($first_post['title']); ?></a></h2>
                                </header>

                                <div class="entry-content">
                                    <p><?php echo wp_kses_post($first_post['excerpt']); ?></p>
                                </div><!-- .entry-content -->
                            </div><!-- .entry-container -->
                        </article>
                    </div><!-- .half-width -->

                    <div class="half-width widget_recent_news">
                        <ul>
                        <?php foreach($content_details as $content): ?>
                            <li>
                                <a href="<?php echo esc_url($content['url']);?>"><img src="<?php echo esc_url($content['image']);?>" alt="<?php echo esc_attr($content['title']);?>"></a>
                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category('', '', $content['id'])?>
                                        </span><!-- .cat-links -->
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                    </header>
                                </div><!-- .entry-container -->
                            </li>
                        <?php endforeach; ?>

                        </ul>
                    </div><!-- .half-width -->
                </div><!-- .media-posts-wrapper -->
            </div><!-- #magazine_pro_media_posts_section -->
            
    <?php }
endif;  ?>
