<?php
/**
 * Hero Banner Section options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add Hero Banner section
$wp_customize->add_section( 'rise_magazine_hero_banner_section',
	array(
		'title'             => esc_html__( 'Hero Banner','rise-magazine' ),
		'description'       => esc_html__( 'Hero Banner Section options.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_front_page_panel',
	)
);

// Hero Banner content enable control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[hero_banner_section_enable]', 
	array(
		'default'			=> 	$options['hero_banner_section_enable'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	) 
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[hero_banner_section_enable]',
		array(
			'label'             => esc_html__( 'Hero Banner Section Enable', 'rise-magazine' ),
			'section'           => 'rise_magazine_hero_banner_section',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);

// Hero Banner content type control and setting
$wp_customize->add_setting( 'rise_magazine_theme_options[hero_banner_content_type]',
	array(
		'default'          	=> $options['hero_banner_content_type'],
		'sanitize_callback' => 'rise_magazine_sanitize_select',
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[hero_banner_content_type]',
	array(
		'label'             => esc_html__( 'Content Type', 'rise-magazine' ),
		'section'           => 'rise_magazine_hero_banner_section',
		'type'				=> 'select',
		'active_callback' 	=> 'rise_magazine_is_hero_banner_section_enable',
		'choices'			=> rise_magazine_hero_banner_content_type(),
	)
);

for ( $i = 1; $i <= 5; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'rise_magazine_theme_options[hero_banner_content_post_' . $i . ']',
        array(
            'sanitize_callback' => 'rise_magazine_sanitize_page',
        )
    );

    $wp_customize->add_control( new Rise_Magazine_Dropdown_Chooser( $wp_customize,
        'rise_magazine_theme_options[hero_banner_content_post_' . $i . ']',
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'rise-magazine' ), $i ),
                'section'           => 'rise_magazine_hero_banner_section',
                'choices'           => rise_magazine_post_choices(),
                'active_callback'   => 'rise_magazine_is_hero_banner_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('rise_magazine_theme_options[hero_banner_separator'. $i .']',
        array(
            'sanitize_callback'      => 'rise_magazine_sanitize_html',
        )
    );

    $wp_customize->add_control(new Rise_Magazine_Customize_Horizontal_Line($wp_customize,
        'rise_magazine_theme_options[hero_banner_separator'. $i .']',
            array(
                'active_callback'       => 'rise_magazine_is_hero_banner_section_enable',
                'type'                  =>'hr',
                'section'               =>'rise_magazine_hero_banner_section',
            )
        )
    );
    
endfor;
