<?php
/**
* Homepage (Static ) options
*
* @package Theme Palace
* @subpackage Rise Magazine
* @since Rise Magazine 1.0.0
*/

// Homepage (Static ) setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[enable_frontpage_content]',
	array(
		'sanitize_callback'   => 'rise_magazine_sanitize_checkbox',
		'default'             => $options['enable_frontpage_content'],
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[enable_frontpage_content]',
	array(
		'label'       	=> esc_html__( 'Enable Content', 'rise-magazine' ),
		'description' 	=> esc_html__( 'Check to enable content on static front page only.', 'rise-magazine' ),
		'section'     	=> 'static_front_page',
		'type'        	=> 'checkbox',
		'active_callback' => 'rise_magazine_is_static_homepage_enable',
	)
);