<?php
/**
 * Layout options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add sidebar section
$wp_customize->add_section( 'rise_magazine_layout',
	array(
		'title'               => esc_html__('Layout','rise-magazine'),
		'description'         => esc_html__( 'Layout section options.', 'rise-magazine' ),
		'panel'               => 'rise_magazine_theme_options_panel',
	)
);

// Site layout setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[site_layout]',
	array(
		'sanitize_callback'   => 'rise_magazine_sanitize_select',
		'default'             => $options['site_layout'],
	)
);

$wp_customize->add_control(  new  Rise_Magazine_Custom_Radio_Image_Control ( $wp_customize,
	'rise_magazine_theme_options[site_layout]',
		array(
			'label'               => esc_html__( 'Site Layout', 'rise-magazine' ),
			'section'             => 'rise_magazine_layout',
			'choices'			  => rise_magazine_site_layout(),
		)
	)
);

// Sidebar position setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[sidebar_position]',
	array(
		'sanitize_callback'   => 'rise_magazine_sanitize_select',
		'default'             => $options['sidebar_position'],
	)
);

$wp_customize->add_control(  new  Rise_Magazine_Custom_Radio_Image_Control ( $wp_customize,
	'rise_magazine_theme_options[sidebar_position]',
		array(
			'label'               => esc_html__( 'Global Sidebar Position', 'rise-magazine' ),
			'section'             => 'rise_magazine_layout',
			'choices'			  => rise_magazine_global_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[post_sidebar_position]',
	array(
		'sanitize_callback'   => 'rise_magazine_sanitize_select',
		'default'             => $options['post_sidebar_position'],
	)
);

$wp_customize->add_control(  new  Rise_Magazine_Custom_Radio_Image_Control ( $wp_customize,
	'rise_magazine_theme_options[post_sidebar_position]',
		array(
			'label'               => esc_html__( 'Posts Sidebar Position', 'rise-magazine' ),
			'section'             => 'rise_magazine_layout',
			'choices'			  => rise_magazine_sidebar_position(),
		)
	)
);

// Post sidebar position setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[page_sidebar_position]',
	array(
		'sanitize_callback'   => 'rise_magazine_sanitize_select',
		'default'             => $options['page_sidebar_position'],
	)
);

$wp_customize->add_control( new  Rise_Magazine_Custom_Radio_Image_Control( $wp_customize,
	'rise_magazine_theme_options[page_sidebar_position]',
		array(
			'label'               => esc_html__( 'Pages Sidebar Position', 'rise-magazine' ),
			'section'             => 'rise_magazine_layout',
			'choices'			  => rise_magazine_sidebar_position(),
		)
	)
);