<?php
/**
 * Excerpt options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

// Add excerpt section
$wp_customize->add_section( 'rise_magazine_single_post_section',
	array(
		'title'             => esc_html__( 'Single Post','rise-magazine' ),
		'description'       => esc_html__( 'Options to change the single posts globally.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_theme_options_panel',
	)
);

// Archive date meta setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[single_post_hide_date]',
	array(
		'default'           => $options['single_post_hide_date'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[single_post_hide_date]',
		array(
			'label'             => esc_html__( 'Hide Date', 'rise-magazine' ),
			'section'           => 'rise_magazine_single_post_section',
			'on_off_label' 		=> rise_magazine_hide_options(),
		)
	)
);

// Archive author meta setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[single_post_hide_author]',
	array(
		'default'           => $options['single_post_hide_author'],
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[single_post_hide_author]',
		array(
			'label'             => esc_html__( 'Hide Author', 'rise-magazine' ),
			'section'           => 'rise_magazine_single_post_section',
			'on_off_label' 		=> rise_magazine_hide_options(),
		)
	)
);
