<?php
/**
* Customizer validation functions
*
* @package Theme Palace
* @subpackage  Rise Magazine
* @since  Rise Magazine 1.0.0
*/

if ( ! function_exists( 'rise_magazine_validate_long_excerpt' ) ) :
    function rise_magazine_validate_long_excerpt( $validity, $value ){
        $value = intval( $value );
        if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
        } elseif ( $value < 5 ) {
            $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'rise-magazine' ) );
        } elseif ( $value > 100 ) {
            $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'rise-magazine' ) );
        }
        return $validity;
    }
endif;


if ( ! function_exists( 'rise_magazine_validate_fashion_news_count' ) ) :
    function rise_magazine_validate_fashion_news_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 2 ) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'rise-magazine' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_testimonial_count' ) ) :
    function rise_magazine_validate_testimonial_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 3 ) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'rise-magazine' ) );
       } elseif ( $value > 9 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 9', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_hero_banner_count' ) ) :
    function rise_magazine_validate_hero_banner_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 1 ) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'rise-magazine' ) );
       } elseif ( $value > 10 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;


if ( ! function_exists( 'rise_magazine_validate_latest_posts_count' ) ) :
    function rise_magazine_validate_latest_posts_count( $validity, $value ){
           $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 2) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'rise-magazine' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_business_news_count' ) ) :
    function rise_magazine_validate_business_news_count( $validity, $value ){
        $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
           $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 2) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'rise-magazine' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_breaking_news_count' ) ) :
    function rise_magazine_validate_breaking_news_count( $validity, $value ){
            $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 2) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'rise-magazine' ) );
       } elseif ( $value > 9 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 9', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_team_count' ) ) :
    function rise_magazine_validate_team_count( $validity, $value ){
            $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 3) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 3', 'rise-magazine' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

if ( ! function_exists( 'rise_magazine_validate_event_count' ) ) :
    function rise_magazine_validate_event_count( $validity, $value ){
            $value = intval( $value );
       if ( empty( $value ) || ! is_numeric( $value ) ) {
            $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'rise-magazine' ) );
       } elseif ( $value < 1) {
           $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'rise-magazine' ) );
       } elseif ( $value > 12 ) {
           $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'rise-magazine' ) );
       }
       return $validity;
    }
endif;

