<?php
/**
 * Blog section
 *
 * This is the template for the content of related_posts section
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */
if ( ! function_exists( 'rise_magazine_add_related_posts_section' ) ) :
    /**
    * Add related_posts section
    *
    *@since  Rise Magazine 1.0.0
    */
    function rise_magazine_add_related_posts_section() {
        $options = rise_magazine_get_theme_options();
        // Check if related_posts is enabled on frontpage
        $related_posts_enable = apply_filters( 'rise_magazine_section_status', true, 'related_posts_section_enable' );

        if ( true !== $related_posts_enable ) {
            return false;
        }
        // Get related_posts section details
        $section_details = array();
        $section_details = apply_filters( 'rise_magazine_filter_related_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }
        // Render related_posts section now.
        rise_magazine_render_related_posts_section( $section_details );
    }
endif;

if ( ! function_exists( 'rise_magazine_get_related_posts_section_details' ) ) :
    /**
    * related_posts section details.
    *
    * @since  Rise Magazine 1.0.0
    * @param array $input related_posts section details.
    */
    function rise_magazine_get_related_posts_section_details( $input ) {
        $options = rise_magazine_get_theme_options();

        // Content type.
        $related_posts_count = 4;
        $content = array();

        $cat_id = ! empty( $options['related_posts_content_category'] ) ? $options['related_posts_content_category'] : '';
        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => absint( $related_posts_count ),
            'cat'                   => absint( $cat_id ),
            'ignore_sticky_posts'   => true,
        );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'medium_large' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-600x450.jpg';
                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// related_posts section content details.
add_filter( 'rise_magazine_filter_related_posts_section_details', 'rise_magazine_get_related_posts_section_details' );


if ( ! function_exists( 'rise_magazine_render_related_posts_section' ) ) :
  /**
   * Start related_posts section
   *
   * @return string related_posts content
   * @since  Rise Magazine 1.0.0
   *
   */
   function rise_magazine_render_related_posts_section( $content_details = array() ) {
        $options                = rise_magazine_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
            <div id="magazine_pro_related_posts_section" class="grid-layout">
                <div class="wrapper">
                    <?php if ( $options['related_posts_title'] ): ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $options['related_posts_title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif ?>
                    
                    <div class="section-content col-4 clear">
                    <?php foreach($content_details as $content): ?>
                        <article class="has-post-thumbnail">
                            <div class="featured-image" style="background-image: url('<?php echo esc_url($content['image']); ?>');">
                                <a href="<?php echo esc_url($content['url']); ?>" class="post-thumbnail-link" title="<?php echo esc_attr($content['title']) ?>"></a>
                            </div><!-- .featured-image -->

                            <div class="entry-container">
                                <div class="entry-meta">
                                <?php rise_magazine_posted_on($content['id']); ?>
                                <?php echo rise_magazine_author($content['id']); ?>
                                </div><!-- .entry-meta -->

                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php echo esc_url($content['url']);?>" tabindex="0"><?php echo esc_html($content['title']) ?></a></h2>
                                </header>
                            </div><!-- .entry-container -->
                        </article>
                        <?php endforeach; ?>

                    </div><!-- .section-content -->

                </div><!-- .wrapper -->
            </div><!-- #magazine_pro_related_posts_section -->
            
    <?php }
endif;  ?>
