<?php
/**
 * Breadcrumb options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

$wp_customize->add_section( 'rise_magazine_breadcrumb',
	array(
		'title'             => esc_html__( 'Breadcrumb','rise-magazine' ),
		'description'       => esc_html__( 'Breadcrumb section options.', 'rise-magazine' ),
		'panel'             => 'rise_magazine_theme_options_panel',
	)
);

// Breadcrumb enable setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[breadcrumb_enable]',
	array(
		'sanitize_callback' => 'rise_magazine_sanitize_switch_control',
		'default'          	=> $options['breadcrumb_enable'],
	)
);

$wp_customize->add_control( new  Rise_Magazine_Switch_Control( $wp_customize,
	'rise_magazine_theme_options[breadcrumb_enable]',
		array(
			'label'            	=> esc_html__( 'Enable Breadcrumb', 'rise-magazine' ),
			'section'          	=> 'rise_magazine_breadcrumb',
			'on_off_label' 		=> rise_magazine_switch_options(),
		)
	)
);

// Breadcrumb separator setting and control.
$wp_customize->add_setting( 'rise_magazine_theme_options[breadcrumb_separator]',
	array(
		'sanitize_callback'	=> 'sanitize_text_field',
		'default'          	=> $options['breadcrumb_separator'],
	)
);

$wp_customize->add_control( 'rise_magazine_theme_options[breadcrumb_separator]',
	array(
		'label'            	=> esc_html__( 'Separator', 'rise-magazine' ),
		'active_callback' 	=> 'rise_magazine_is_breadcrumb_enable',
		'section'          	=> 'rise_magazine_breadcrumb',
	)
);
