<?php
/**
 * Theme Palace options
 *
 * @package Theme Palace
 * @subpackage  Rise Magazine
 * @since  Rise Magazine 1.0.0
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function rise_magazine_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'rise-magazine' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function rise_magazine_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'rise-magazine' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    wp_reset_postdata();
    return  $choices;
}

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function rise_magazine_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'rise-magazine' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}


if ( ! function_exists( 'rise_magazine_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function rise_magazine_site_layout() {
        $rise_magazine_site_layout = array(
            'wide'          => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
            'boxed-layout'  => esc_url( get_template_directory_uri() . '/assets/images/boxed.png' ),
        );

        $output = apply_filters( 'rise_magazine_site_layout', $rise_magazine_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'rise_magazine_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function rise_magazine_selected_sidebar() {
        $rise_magazine_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'rise-magazine' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'rise-magazine' ),
        );

        $output = apply_filters( 'rise_magazine_selected_sidebar', $rise_magazine_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'rise_magazine_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function rise_magazine_global_sidebar_position() {
        $rise_magazine_global_sidebar_position = array(
            'right-sidebar' => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar'    => esc_url( get_template_directory_uri() . '/assets/images/full.png' ),
        );

        $output = apply_filters( 'rise_magazine_global_sidebar_position', $rise_magazine_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'rise_magazine_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function rise_magazine_sidebar_position() {
        $rise_magazine_sidebar_position = array(
            'right-sidebar'         => esc_url( get_template_directory_uri() . '/assets/images/right.png' ),
            'no-sidebar-content'    => esc_url( get_template_directory_uri() . '/assets/images/boxed.png' ),
        );

        $output = apply_filters( 'rise_magazine_sidebar_position', $rise_magazine_sidebar_position );

        return $output;
    }
endif;

if ( ! function_exists( 'rise_magazine_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function rise_magazine_pagination_options() {
        $rise_magazine_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'rise-magazine' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'rise-magazine' ),
        );

        $output = apply_filters( 'rise_magazine_pagination_options', $rise_magazine_pagination_options );

        return $output;
    }
endif;


if ( ! function_exists( 'rise_magazine_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function rise_magazine_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'rise-magazine' ),
            'off'       => esc_html__( 'Disable', 'rise-magazine' )
        );
        return apply_filters( 'rise_magazine_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'rise_magazine_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function rise_magazine_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'rise-magazine' ),
            'off'       => esc_html__( 'No', 'rise-magazine' )
        );
        return apply_filters( 'rise_magazine_hide_options', $arr );
    }
endif;


if ( ! function_exists( 'rise_magazine_hero_banner_content_type' ) ) :
    /**
     * Product Options
     * @return array site product options
     */
    function rise_magazine_hero_banner_content_type() {
        $rise_magazine_hero_banner_content_type = array(
			'post' 		=> esc_html__( 'Post', 'rise-magazine' ),
        );

        $output = apply_filters( 'rise_magazine_hero_banner_content_type', $rise_magazine_hero_banner_content_type );

        return $output;
    }
endif;
